IF OBJECT_ID('P_EST_MOVIMENTO_VENDAS_FORMA_PGTO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_MOVIMENTO_VENDAS_FORMA_PGTO
	END
GO
--EXEC P_EST_MOVIMENTO_VENDAS_FORMA_PGTO 1,'1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30','2018-06-01','2018-06-30'
CREATE PROCEDURE P_EST_MOVIMENTO_VENDAS_FORMA_PGTO @CD_EMP INT, @CD_FILIAIS VARCHAR(MAX),@DT_INI DATETIME, @DT_FIM DATETIME
AS
BEGIN
SET NOCOUNT ON;
DECLARE @FILIAL INT
DECLARE @vlrDinheiro money
DEClARE @VlrCheque money
DECLARE @VLRCARTAO MONEY
DECLARE @VLRTICKETS MONEY
DECLARE @VLRDUPLICATA MONEY
DECLARE @VLRCONVENIO MONEY
DECLARE @VLRCONVENIOPBM MONEY
DECLARE @VLRNCC MONEY
DECLARE @DsTipoMovimento VARCHAR(200)
DECLARE @DsOrigemVenda VARCHAR(150)
DECLARE @DtMovimento DATETIME
	CREATE TABLE #_RS_FILIAL (CD_EMP INT, CD_FILIAL		INT)

	INSERT INTO #_RS_FILIAL 						
	SELECT 
		CD_EMP,
		CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE
		CD_EMP = @CD_EMP
		AND CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAIS))

CREATE TABLE #RsPartPgto (Filial int,
						  DtMovimento DATETIME,
						  Moeda varchar(50),
						  DsTipoMovimento varchar(200),
						  DsOrigemVenda varchar(150),
						  VlrMovimento money)
CREATE TABLE #RsFormaPgto (FILIAL int,
						   DtMovimento datetime,
						   DsTipoMovimento varchar(200),
						   DsOrigemVenda varchar(150),
						   VLRDINHEIRO money,
						   VLRCHEQUES money,
						   VLRCARTAO money,
						   VLRTICKETS money,
						   VLRDUPLICATA money,
						   VLRCONVENIO money,
						   VLRCONVENIOPBM money,
						   VLRNCC money)

insert into #RsFormaPgto
SELECT
	FILIAL,
	DtMovimento,
	DsTipoMovimento,
	DsOrigemVenda,
	SUM(VLRDINHEIRO) AS VLRDINHEIRO,
	SUM(VLRCHEQUES) AS VLRCHEQUES,
	SUM(VLRCARTAO) AS VLRCARTAO,
	SUM(VLRTICKETS) AS VLRTICKETS,
	SUM(VLRDUPLICATA) AS VLRDUPLICATA,
	SUM(VLRCONVENIO) AS VLRCONVENIO,
	SUM(VLRCONVENIOPBM) AS VLRCONVENIOPBM,
	SUM(VLRNCC) AS VLRNCC
FROM
	V_RELATORIO_MOVIMENTO_VENDAS INNER JOIN #_RS_FILIAL f ON
	V_RELATORIO_MOVIMENTO_VENDAS.filial = f.cd_filial
WHERE
	DTMOVIMENTO BETWEEN @DT_INI AND @DT_FIM
GROUP BY
	FILIAL,
	DsTipoMovimento,
	DsOrigemVenda,
	DtMovimento

	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'Dinheiro',
		DsTipoMovimento,
		DsOrigemVenda,
		vlrDinheiro
	from 
		#RsFormaPgto
	WHERE
		vlrDinheiro <>0

	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'Cheque',
		DsTipoMovimento,
		DsOrigemVenda,
		VLRCHEQUES
	from 
		#RsFormaPgto
	WHERE
		VLRCHEQUES <>0

	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'Cartao',
		DsTipoMovimento,
		DsOrigemVenda,
		VLRCARTAO
	from 
		#RsFormaPgto
	WHERE
		VLRCARTAO <>0

	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'ValesCompras\Tickets',
		DsTipoMovimento,
		DsOrigemVenda,
		VLRTICKETS
	from 
		#RsFormaPgto
	WHERE
		VLRTICKETS <>0
	
	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'Duplicata',
		DsTipoMovimento,
		DsOrigemVenda,
		VLRDUPLICATA
	from 
		#RsFormaPgto
	WHERE
		VLRDUPLICATA <>0

	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'Convenio',
		DsTipoMovimento,
		DsOrigemVenda,
		VLRCONVENIO
	from 
		#RsFormaPgto
	WHERE
		VLRCONVENIO <>0


	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'ConvenioPBM',
		DsTipoMovimento,
		DsOrigemVenda,
		VLRCONVENIOPBM
	from 
		#RsFormaPgto
	WHERE
		VLRCONVENIOPBM <>0

	insert into #RsPartPgto
	select
		FILIAL,
		DtMovimento,
		'NCC',
		DsTipoMovimento,
		DsOrigemVenda,
		VLRNCC
	from 
		#RsFormaPgto
	WHERE
		VLRNCC <>0
		
select
	*
from
	#RsPartPgto
RETURN

DROP TABLE #RsPartPgto;
DROP TABLE #RsFormaPgto;
END